<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PageSection extends Model 
{

    protected $table = 'page_sections';
    public $timestamps = true;
    protected $fillable = array('page_id', 'section_id', 'sort', 'status', 'published_at');

    public function pages()
    {
        return $this->belongsTo('Page', 'page_id');
    }

    public function sections()
    {
        return $this->belongsTo('Section', 'section_id');
    }

}